'/***
'*string.h - declarations for string manipulation functions
'*
'*       Copyright (c) 1985-1997, Microsoft Corporation. All rights reserved.
'*
'*Purpose:
'*       This file contains the function declarations for the string
'*       manipulation functions.
'*       [ANSI/System V]
'*
'*       [Public]
'*
'****/

' Note: Added an underscore to the ansi string functions because the name of many
' of them conflicts with the string functions declared in shlwapi.inc

#If Not %Def(%STRING_INC)
    %STRING_INC = 1

'typedef unsigned int size_t;
'typedef unsigned short wchar_t;

#If Not %Def(%NLSCMP_DEFINED)
%NLSCMP_DEFINED = 1
%NLSCMPERROR   = 2147483647  ' /* currently == INT_MAX */
#EndIf

'/* Function prototypes */

'_CRTIMP void *  __cdecl memcpy(void *, const void *, size_t);
Declare Function memcpy CDecl Lib "msvcrt.dll" Alias "memcpy" ( _
   ByVal Dword, _                           ' void *dest
   ByVal Dword, _                           ' const void *src
   ByVal Dword _                            ' size_t count
   ) As Dword                               ' void *

'_CRTIMP int     __cdecl memcmp(const void *, const void *, size_t);
Declare Function memcmp CDecl Lib "msvcrt.dll" Alias "memcmp" ( _
   ByVal Dword, _                           ' const void *buf1
   ByVal Dword, _                           ' const void *buf2
   ByVal Dword _                            ' size_t count
   ) As Long                                ' int

'_CRTIMP void *  __cdecl memset(void *, int, size_t);
Declare Function memset CDecl Lib "msvcrt.dll" Alias "memset" ( _
   ByVal Dword, _                           ' void *dest
   ByVal Long, _                            ' int c
   ByVal Dword _                            ' size_t count
   ) As Dword                               ' void *

'_CRTIMP char *  __cdecl _strset(char *, int);
Declare Function strset_ CDecl Lib "msvcrt.dll" Alias "_strset" ( _
   ByRef Asciiz, _                          ' char *string
   ByVal Long _                             ' int c
   ) As Dword                               ' char *

'_CRTIMP char *  __cdecl strcpy(char *, const char *);
Declare Function strcpy_ CDecl Lib "msvcrt.dll" Alias "strcpy" ( _
   ByRef Asciiz, _                          ' char *strDestination
   ByRef Asciiz _                           ' const char *strSource
   ) As Dword                               ' char *

'_CRTIMP char *  __cdecl strcat(char *, const char *);
Declare Function strcat_ CDecl Lib "msvcrt.dll" Alias "strcat" ( _
   ByRef Asciiz, _                          ' char *strDestination
   ByRef Asciiz _                           ' const char *strSource
   ) As Dword                               ' char *

'_CRTIMP int     __cdecl strcmp(const char *, const char *);
Declare Function strcmp_ CDecl Lib "msvcrt.dll" Alias "strcmp" ( _
   ByRef Asciiz, _                          ' const char *string1
   ByRef Asciiz _                           ' const char *string2
   ) As Long                                ' int

'_CRTIMP size_t  __cdecl strlen(const char *);
Declare Function strlen_ CDecl Lib "msvcrt.dll" Alias "strlen" ( _
   ByRef Asciiz _                           ' const char *string
   ) As Dword                               ' size_t

'_CRTIMP void *  __cdecl _memccpy(void *, const void *, int, unsigned int);
Declare Function memccpy CDecl Lib "msvcrt.dll" Alias "_memccpy" ( _
   ByVal Dword, _                           ' void *dest
   ByVal Dword, _                           ' const void *src
   ByVal Long, _                            ' int  c
   ByVal Dword _                            ' unsigned int count
   ) As Dword                               ' void *

'_CRTIMP void *  __cdecl memchr(const void *, int, size_t);
Declare Function memchr CDecl Lib "msvcrt.dll" Alias "memchr" ( _
   ByVal Dword, _                           ' const void *buf
   ByVal Long, _                            ' int  c
   ByVal Dword _                            ' size_t count
   ) As Dword                               ' void *

'_CRTIMP int     __cdecl _memicmp(const void *, const void *, unsigned int);
Declare Function memicmp CDecl Lib "msvcrt.dll" Alias "_memicmp" ( _
   ByVal Dword, _                           ' const void *buf1
   ByVal Dword, _                           ' const void *buf2
   ByVal Dword _                            ' unsigned int count
   ) As Long                                ' int

'_CRTIMP void *  __cdecl memmove(void *, const void *, size_t);
Declare Function memmove CDecl Lib "msvcrt.dll" Alias "memmove" ( _
   ByVal Dword, _                           ' void *dest
   ByVal Dword, _                           ' const void *src
   ByVal Dword _                            ' size_t count
   ) As Dword                               ' void *

'_CRTIMP char *  __cdecl strchr(const char *, int);
Declare Function strchr_ CDecl Lib "msvcrt.dll" Alias "strchr" ( _
   ByRef Asciiz, _                          ' const char *string
   ByVal Long _                             ' int c
   ) As Dword                               ' char *

'_CRTIMP int     __cdecl _strcmpi(const char *, const char *);
Declare Function strcmpi_ CDecl Lib "msvcrt.dll" Alias "_strcmpi" ( _
   ByRef Asciiz, _                          ' const char *string1
   ByRef Asciiz _                           ' const char *string2
   ) As Long                                ' int

'_CRTIMP int     __cdecl _stricmp(const char *, const char *);
Declare Function stricmp_ CDecl Lib "msvcrt.dll" Alias "_stricmp" ( _
   ByRef Asciiz, _                          ' const char *string1
   ByRef Asciiz _                           ' const char *string2
   ) As Long                                ' int

'_CRTIMP int     __cdecl strcoll(const char *, const char *);
Declare Function strcoll_ CDecl Lib "msvcrt.dll" Alias "strcoll" ( _
   ByRef Asciiz, _                          ' const char *string1
   ByRef Asciiz _                           ' const char *string2
   ) As Long                                ' int

'_CRTIMP int     __cdecl _stricoll(const char *, const char *);
Declare Function stricoll_ CDecl Lib "msvcrt.dll" Alias "_stricoll" ( _
   ByRef Asciiz, _                          ' const char *string1
   ByRef Asciiz _                           ' const char *string2
   ) As Long                                ' int

'_CRTIMP int     __cdecl _strncoll(const char *, const char *, size_t);
Declare Function strncoll_ CDecl Lib "msvcrt.dll" Alias "_strncoll" ( _
   ByRef Asciiz, _                          ' const char *string1
   ByRef Asciiz, _                          ' const char *string2
   ByVal Dword _                            ' size_t count
   ) As Long                                ' int

'_CRTIMP int     __cdecl _strnicoll(const char *, const char *, size_t);
Declare Function strnicoll_ CDecl Lib "msvcrt.dll" Alias "_strnicoll" ( _
   ByRef Asciiz, _                          ' const char *string1
   ByRef Asciiz, _                          ' const char *string2
   ByVal Dword _                            ' size_t count
   ) As Long                                ' int

'_CRTIMP size_t  __cdecl strcspn(const char *, const char *);
Declare Function strcspn_ CDecl Lib "msvcrt.dll" Alias "strcspn" ( _
   ByRef Asciiz, _                          ' const char *string1
   ByRef Asciiz _                           ' const char *string2
   ) As Dword                               ' size_t

'_CRTIMP char *  __cdecl _strdup(const char *);
Declare Function strdup_ CDecl Lib "msvcrt.dll" Alias "_strdup" ( _
   ByRef Asciiz _                           ' const char *strSource
   ) As Dword                               ' char *

'_CRTIMP char *  __cdecl _strerror(const char *);
Declare Function strerror_ CDecl Lib "msvcrt.dll" Alias "_strerror" ( _
   ByRef Asciiz _                           ' const char *strErrMsg
   ) As Dword                               ' char *

'_CRTIMP char *  __cdecl strerror(int);
Declare Function strerror CDecl Lib "msvcrt.dll" Alias "strerror" ( _
   ByVal Long _                             ' int errnum
   ) As Dword                               ' char *

'_CRTIMP char *  __cdecl _strlwr(char *);
Declare Function strlwr_ CDecl Lib "msvcrt.dll" Alias "_strlwr" ( _
   ByRef Asciiz _                           ' char *str
   ) As Dword                               ' char *

'_CRTIMP char *  __cdecl strncat(char *, const char *, size_t);
Declare Function strncat_ CDecl Lib "msvcrt.dll" Alias "strncat" ( _
   ByRef Asciiz, _                          ' char *strDest
   ByRef Asciiz, _                          ' const char *strSource
   ByVal Dword _                            ' size_t count
   ) As Dword                               ' char *

'_CRTIMP int     __cdecl strncmp(const char *, const char *, size_t);
Declare Function strncmp_ CDecl Lib "msvcrt.dll" Alias "strncmp" ( _
   ByRef Asciiz, _                          ' const char *string1
   ByRef Asciiz _                           ' const char *string2
   ) As Long                                ' int

'_CRTIMP int     __cdecl _strnicmp(const char *, const char *, size_t);
Declare Function strnicmp_ CDecl Lib "msvcrt.dll" Alias "_strnicmp" ( _
   ByRef Asciiz, _                          ' const char *string1
   ByRef Asciiz, _                          ' const char *string2
   ByVal Dword _                            ' size_t count
   ) As Long                                ' int

'_CRTIMP char *  __cdecl strncpy(char *, const char *, size_t);
Declare Function strncpy_ CDecl Lib "msvcrt.dll" Alias "strncpy" ( _
   ByRef Asciiz, _                          ' char *strDest
   ByRef Asciiz, _                          ' const char *strSource
   ByVal Dword _                            ' size_t count
   ) As Dword                               ' char *

'_CRTIMP char *  __cdecl _strnset(char *, int, size_t);
Declare Function strnset_ CDecl Lib "msvcrt.dll" Alias "_strnset" ( _
   ByRef Asciiz, _                          ' char *string
   ByVal Long, _                            ' int c
   ByVal Dword _                            ' size_t
   ) As Dword                               ' char *

'_CRTIMP char *  __cdecl strpbrk(const char *, const char *);
Declare Function strpbrk_ CDecl Lib "msvcrt.dll" Alias "strpbrk" ( _
   ByRef Asciiz, _                          ' const char *string1
   ByRef Asciiz _                           ' const char *string2
   ) As Dword                               ' char *

'_CRTIMP char *  __cdecl strrchr(const char *, int);
Declare Function strrchr_ CDecl Lib "msvcrt.dll" Alias "strrchr" ( _
   ByRef Asciiz, _                          ' const char *string
   ByVal Long _                             ' int c
   ) As Dword                               ' char *

'_CRTIMP char *  __cdecl _strrev(char *);
Declare Function strrev_ CDecl Lib "msvcrt.dll" Alias "_strrev" ( _
   ByRef Asciiz _                           ' char *string
   ) As Dword                               ' char *

'_CRTIMP size_t  __cdecl strspn(const char *, const char *);
Declare Function strspn_ CDecl Lib "msvcrt.dll" Alias "strspn" ( _
   ByRef Asciiz, _                          ' const char *string
   ByRef Asciiz _                           ' const char *strCharSet
   ) As Dword                               ' size_t

'_CRTIMP char *  __cdecl strstr(const char *, const char *);
Declare Function strstr_ CDecl Lib "msvcrt.dll" Alias "strstr" ( _
   ByRef Asciiz, _                          ' const char *string
   ByRef Asciiz _                           ' const char *strSearch
   ) As Dword                               ' char *

'_CRTIMP char *  __cdecl strtok(char *, const char *);
Declare Function strtok_ CDecl Lib "msvcrt.dll" Alias "strtok" ( _
   ByRef Asciiz, _                          ' char *strToken
   ByRef Asciiz _                           ' const char *strDelimit
   ) As Dword                               ' char *

'_CRTIMP char *  __cdecl _strupr(char *);
Declare Function strupr_ CDecl Lib "msvcrt.dll" Alias "_strupr" ( _
   ByRef Asciiz _                           ' char *string
   ) As Dword                               ' char *

'_CRTIMP size_t  __cdecl strxfrm (char *, const char *, size_t);
Declare Function strxfrm_ CDecl Lib "msvcrt.dll" Alias "strxfrm" ( _
   ByRef Asciiz, _                          ' char *strDest
   ByRef Asciiz, _                          ' const char *strSource
   ByVal Dword _                            ' size_t count
   ) As Dword                               ' size_t


#If Not %Def(%WSTRING_DEFINED)
%WSTRING_DEFINED = 1

'/* wide function prototypes, also declared in wchar.h  */

'_CRTIMP wchar_t * __cdecl wcscat(wchar_t *, const wchar_t *);
Declare Function wcscat CDecl Lib "msvcrt.dll" Alias "wcscat" ( _
   ByVal Dword, _                           ' wchar_t *strDestination
   ByVal Dword _                            ' const wchar_t *strSource
   ) As Dword                               ' wchar_t *

'_CRTIMP wchar_t * __cdecl wcschr(const wchar_t *, wchar_t);
Declare Function wcschr CDecl Lib "msvcrt.dll" Alias "wcschr" ( _
   ByVal Dword, _                           ' const wchar_t *string
   ByVal Long _                             ' int c
   ) As Dword                               ' wchar_t *

'_CRTIMP int __cdecl wcscmp(const wchar_t *, const wchar_t *);
Declare Function wcscmp CDecl Lib "msvcrt.dll" Alias "wcscmp" ( _
   ByVal Dword, _                           ' const wchar_t *string1
   ByVal Dword _                            ' const wchar_t *string2
   ) As Long                                ' int

'_CRTIMP wchar_t * __cdecl wcscpy(wchar_t *, const wchar_t *);
Declare Function wcscpy CDecl Lib "msvcrt.dll" Alias "wcscpy" ( _
   ByVal Dword, _                           ' wchar_t *strDestination
   ByVal Dword _                            ' const wchar_t *strSource
   ) As Dword                               ' wchar_t *

'_CRTIMP size_t __cdecl wcscspn(const wchar_t *, const wchar_t *);
Declare Function wcscspn CDecl Lib "msvcrt.dll" Alias "wcscspn" ( _
   ByVal Dword, _                           ' const wchar_t *string
   ByVal Dword _                            ' const wchar_t *strCharSet
   ) As Dword                               ' size_t

'_CRTIMP size_t __cdecl wcslen(const wchar_t *);
Declare Function wcslen CDecl Lib "msvcrt.dll" Alias "wcslen" ( _
   ByVal Dword _                            ' const wchar_t *string
   ) As Dword                               ' size_t

'_CRTIMP wchar_t * __cdecl wcsncat(wchar_t *, const wchar_t *, size_t);
Declare Function wcsncat CDecl Lib "msvcrt.dll" Alias "wcsncat" ( _
   ByVal Dword, _                           ' wchar_t *strDest
   ByVal Dword, _                           ' const wchar_t *strSource
   ByVal Dword _                            ' size_t count
   ) As Dword                               ' wchar_t *

'_CRTIMP int __cdecl wcsncmp(const wchar_t *, const wchar_t *, size_t);
Declare Function wcsncmp CDecl Lib "msvcrt.dll" Alias "wcsncmp" ( _
   ByVal Dword, _                           ' const wchar_t *string1
   ByVal Dword _                            ' const wchar_t *string2
   ) As Long                                ' int

'_CRTIMP wchar_t * __cdecl wcsncpy(wchar_t *, const wchar_t *, size_t);
Declare Function wcsncpy CDecl Lib "msvcrt.dll" Alias "wcsncpy" ( _
   ByVal Dword, _                           ' wchar_t *strDest
   ByVal Dword, _                           ' const wchar_t *strSource
   ByVal Dword _                            ' size_t count
   ) As Dword                               ' wchar_t *

'_CRTIMP wchar_t * __cdecl wcspbrk(const wchar_t *, const wchar_t *);
Declare Function wcspbrk CDecl Lib "msvcrt.dll" Alias "wcspbrk" ( _
   ByVal Dword, _                           ' const wchar_t *string1
   ByVal Dword _                            ' const wchar_t *string2
   ) As Dword                               ' wchar_t *

'_CRTIMP wchar_t * __cdecl wcsrchr(const wchar_t *, wchar_t);
Declare Function wcsrchr CDecl Lib "msvcrt.dll" Alias "wcsrchr" ( _
   ByVal Dword, _                           ' const wchar_t *string
   ByVal Word _                             ' wchar_t c
   ) As Dword                               ' wchar_t *

'_CRTIMP size_t __cdecl wcsspn(const wchar_t *, const wchar_t *);
Declare Function wcsspn CDecl Lib "msvcrt.dll" Alias "wcsspn" ( _
   ByVal Dword, _                           ' const wchar_t *string
   ByVal Dword _                            ' const wchar_t *strCharSet
   ) As Dword                               ' size_t

'_CRTIMP wchar_t * __cdecl wcsstr(const wchar_t *, const wchar_t *);
Declare Function wcsstr CDecl Lib "msvcrt.dll" Alias "wcsstr" ( _
   ByVal Dword, _                           ' const wchar_t *string
   ByVal Dword _                            ' const wchar_t *strSearch
   ) As Dword                               ' wchar_t

'_CRTIMP wchar_t * __cdecl wcstok(wchar_t *, const wchar_t *);
Declare Function wcstok CDecl Lib "msvcrt.dll" Alias "wcstok" ( _
   ByVal Dword, _                           ' wchar_t *strToken
   ByVal Dword _                            ' const wchar_t *strDelimit
   ) As Dword                               ' wchar_t *

'_CRTIMP wchar_t * __cdecl _wcsdup(const wchar_t *);
Declare Function wcsdup CDecl Lib "msvcrt.dll" Alias "_wcsdup" ( _
   ByVal Dword _                            ' const wchar_t *strSource
   ) As Dword                               ' wchar_t *

'_CRTIMP int __cdecl _wcsicmp(const wchar_t *, const wchar_t *);
Declare Function wcsicmp CDecl Lib "msvcrt.dll" Alias "_wcsicmp" ( _
   ByVal Dword, _                           ' const wchar_t *string1
   ByVal Dword _                            ' const wchar_t *string2
   ) As Long                                ' int

'_CRTIMP int __cdecl _wcsnicmp(const wchar_t *, const wchar_t *, size_t);
Declare Function wcsnicmp CDecl Lib "msvcrt.dll" Alias "_wcsnicmp" ( _
   ByVal Dword, _                           ' const wchar_t *string1
   ByVal Dword, _                           ' const wchar_t *string2
   ByVal Dword _                            ' size_t count
   ) As Long                                ' int

'_CRTIMP wchar_t * __cdecl _wcsnset(wchar_t *, wchar_t, size_t);
Declare Function wcsnset CDecl Lib "msvcrt.dll" Alias "_wcsnset" ( _
   ByVal Dword, _                           ' wchar_t *string
   ByVal Word, _                            ' wchar_t c
   ByVal Dword _                            ' size_t
   ) As Dword                               ' wchar_t *

'_CRTIMP wchar_t * __cdecl _wcsrev(wchar_t *);
Declare Function wcsrev CDecl Lib "msvcrt.dll" Alias "_wcsrev" ( _
   ByVal Dword _                            ' wchar_t *string
   ) As Dword                               ' wchar_t *

'_CRTIMP wchar_t * __cdecl _wcsset(wchar_t *, wchar_t);
Declare Function wcsset CDecl Lib "msvcrt.dll" Alias "_wcsset" ( _
   ByVal Dword, _                           ' wchar_t *string
   ByVal Word _                             ' wchar_t c
   ) As Dword                               ' wchar_t *

'_CRTIMP wchar_t * __cdecl _wcslwr(wchar_t *);
Declare Function wcslwr CDecl Lib "msvcrt.dll" Alias "_wcslwr" ( _
   ByVal Dword _                            ' wchar_t *str
   ) As Dword                               ' wchar_t *

'_CRTIMP wchar_t * __cdecl _wcsupr(wchar_t *);
Declare Function wcsupr CDecl Lib "msvcrt.dll" Alias "_wcsupr" ( _
   ByVal Dword _                            ' wchar_t *string
   ) As Dword                               ' wchar_t *

'_CRTIMP size_t __cdecl wcsxfrm(wchar_t *, const wchar_t *, size_t);
Declare Function wcsxfrm CDecl Lib "msvcrt.dll" Alias "wcsxfrm" ( _
   ByVal Dword, _                           ' wchar_t *strDest
   ByVal Dword, _                           ' const wchar_t *strSource
   ByVal Dword _                            ' size_t count
   ) As Dword                               ' size_t

'_CRTIMP int __cdecl wcscoll(const wchar_t *, const wchar_t *);
Declare Function wcscoll CDecl Lib "msvcrt.dll" Alias "wcscoll" ( _
   ByVal Dword, _                           ' const wchar_t *string1
   ByVal Dword _                            ' const wchar_t *string2
   ) As Long                                ' int

'_CRTIMP int __cdecl _wcsicoll(const wchar_t *, const wchar_t *);
Declare Function wcsicoll CDecl Lib "msvcrt.dll" Alias "_wcsicoll" ( _
   ByVal Dword, _                           ' const wchar_t *string1
   ByVal Dword _                            ' const wchar_t *string2
   ) As Long                                ' int

'_CRTIMP int __cdecl _wcsncoll(const wchar_t *, const wchar_t *, size_t);
Declare Function wcsncoll CDecl Lib "msvcrt.dll" Alias "_wcsncoll" ( _
   ByVal Dword, _                           ' const wchar_t *string1
   ByVal Dword, _                           ' const wchar_t *string2
   ByVal Dword _                            ' size_t count
   ) As Long                                ' int

'_CRTIMP int __cdecl _wcsnicoll(const wchar_t *, const wchar_t *, size_t);
Declare Function wcsnicoll CDecl Lib "msvcrt.dll" Alias "_wcsnicoll" ( _
   ByVal Dword, _                           ' const wchar_t *string1
   ByVal Dword, _                           ' const wchar_t *string2
   ByVal Dword _                            ' size_t count
   ) As Long                                ' int
      
FUNCTION char2str (BYVAL psz AS ASCIIZ PTR) AS STRING
   If psz Then Function = @psz
End Function

Function wchar2bstr (ByVal pwsz As Dword) As String
   Local nLen As Long
   If pwsz = 0 Then Exit Function
   nLen = wcslen(pwsz)
   If nLen Then Function = Peek$(pwsz, nLen * 2)
End Function

Function wchar2str (ByVal pwsz As Dword) As String
   Local nLen As Long
   If pwsz = 0 Then Exit Function
   nLen = wcslen(pwsz)
   If nLen Then Function = ACode$(Peek$(pwsz, nLen * 2))
End Function 
#EndIf   ' #IF NOT %DEF(%WSTRING_DEFINED)

#EndIf   ' #IF NOT %DEF(%STRING_INC)